<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
include '../connection.php';

$id = isset($_POST['id']) ? intval($_POST['id']) : 0;
$price = isset($_POST['price']) ? floatval($_POST['price']) : -1;

if ($id <= 0 || $price < 0) {
    echo json_encode(["success" => false, "message" => "Invalid input data"]);
    exit;
}

$stmt = $conn->prepare("UPDATE tbl_service_product_prices SET price=? WHERE id=?");
$stmt->bind_param("di", $price, $id);

if ($stmt->execute()) {
    echo json_encode(["success" => true, "message" => "Price updated successfully"]);
} else {
    echo json_encode(["success" => false, "message" => "Failed to update price"]);
}

$stmt->close();
$conn->close();
?>
