<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

include '../connection.php';

$user_id    = $_POST["user_id"] ?? '';
$product_id = $_POST["product_id"] ?? '';
$service_id = $_POST["service_id"] ?? '';
$quantity   = $_POST["quantity"] ?? '';
$unit_price = $_POST["unit_price"] ?? '';
$total_price= $_POST["total_price"] ?? '';

if (empty($user_id) || empty($product_id) || empty($service_id) || empty($quantity)) {
    echo json_encode([
        "success" => false,
        "message" => "Missing required fields"
    ]);
    exit;
}

$sql = "INSERT INTO tblcart (user_id, product_id, service_id, quantity, unit_price, total_price) 
        VALUES (?, ?, ?, ?, ?, ?)";

$stmt = $conn->prepare($sql);
$stmt->bind_param("iiiidd", $user_id, $product_id, $service_id, $quantity, $unit_price, $total_price);

if ($stmt->execute()) {
    echo json_encode([
        "success" => true,
        "message" => "Added to cart successfully"
    ]);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Failed to add to cart"
    ]);
}
