<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json; charset=UTF-8");

include '../connection.php';

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

// ✅ Read input (supports JSON or form-data)
$input = json_decode(file_get_contents("php://input"), true);
if (is_array($input)) {
    $user_id = intval($input['user_id'] ?? 0);
    $order_id = intval($input['order_id'] ?? 0);
    $amount   = floatval($input['amount'] ?? 0);
    $method   = trim($input['method'] ?? 'cod');
} else {
    $user_id = intval($_POST['user_id'] ?? 0);
    $order_id = intval($_POST['order_id'] ?? 0);
    $amount   = floatval($_POST['amount'] ?? 0);
    $method   = trim($_POST['method'] ?? 'cod');
}

if ($order_id <= 0 || $amount <= 0 || empty($method)) {
    echo json_encode(['success' => false, 'msg' => 'Invalid or missing parameters']);
    exit;
}

// Create transaction reference
$tran_id = 'wavoo_' . date('YmdHis') . '_' . mt_rand(1000, 9999);

try {
    // Insert initial transaction
    $stmt = $conn->prepare("INSERT INTO tbl_payment_transactions 
        (order_id, gateway, tran_id, amount, status) 
        VALUES (?, ?, ?, ?, 'INIT')");
    if (!$stmt) {
        throw new Exception("Prepare failed: " . $conn->error);
    }
    $stmt->bind_param('issd', $order_id, $method, $tran_id, $amount);
    $stmt->execute();
    $stmt->close();

    switch ($method) {

        /* -------------------------------------------------------- *
         * 1️⃣ CASH-ON-DELIVERY
         * -------------------------------------------------------- */
        case 'cod':
            $conn->query("UPDATE tbl_order 
                          SET status='Completed', payment_status='COD Confirmed' 
                          WHERE id=$order_id");
            $conn->query("UPDATE tbl_payment_transactions 
                          SET status='SUCCESS' WHERE tran_id='$tran_id'");
            
            $conn->query("DELETE FROM tblcart WHERE user_id = $user_id");

            echo json_encode([
                'success' => true,
                'method' => 'cod',
                'tran_id' => $tran_id,
                'msg' => 'COD confirmed successfully.'
            ]);
            exit;


        /* -------------------------------------------------------- *
         * 2️⃣ SSLCOMMERZ
         * -------------------------------------------------------- */
        case 'sslcommerz':
            // ✅ Replace these with your real credentials
            $store_id   = 'your_store_id';
            $store_pass = 'your_store_password';

            $post_data = [
                'store_id'       => $store_id,
                'store_passwd'   => $store_pass,
                'total_amount'   => number_format($amount, 2, '.', ''),
                'currency'       => 'BDT', // ✅ use BDT for Bangladesh
                'tran_id'        => $tran_id,
                'success_url'    => 'https://your-domain.com/api/payment/ssl_ipn.php',
                'fail_url'       => 'https://your-domain.com/api/payment/ssl_ipn.php',
                'cancel_url'     => 'https://your-domain.com/api/payment/ssl_ipn.php',
                'cus_name'       => 'Wavoo User',
                'cus_email'      => 'client@example.com',
                'cus_add1'       => 'Dhaka',
                'cus_phone'      => '8801XXXXXXXXX',
            ];

            $handle = curl_init('https://securepay.sslcommerz.com/gwprocess/v4/api.php');
            curl_setopt($handle, CURLOPT_TIMEOUT, 30);
            curl_setopt($handle, CURLOPT_POST, 1);
            curl_setopt($handle, CURLOPT_POSTFIELDS, $post_data);
            curl_setopt($handle, CURLOPT_RETURNTRANSFER, true);
            $content = curl_exec($handle);

            if (curl_errno($handle)) {
                throw new Exception("cURL error: " . curl_error($handle));
            }

            curl_close($handle);

            $response = json_decode($content, true);
            if (!empty($response['GatewayPageURL'])) {
                echo json_encode([
                    'success' => true,
                    'method' => 'sslcommerz',
                    'tran_id' => $tran_id,
                    'pay_url' => $response['GatewayPageURL']
                ]);
            } else {
                $conn->query("UPDATE tbl_payment_transactions 
                              SET status='FAILED' WHERE tran_id='$tran_id'");
                echo json_encode(['success' => false, 'msg' => 'SSLCommerz initialization failed']);
            }
            exit;


        /* -------------------------------------------------------- *
         * 3️⃣ STRIPE
         * -------------------------------------------------------- */
        case 'stripe':
            require_once 'vendor/autoload.php'; // composer require stripe/stripe-php

            \Stripe\Stripe::setApiKey('sk_test_...'); // ✅ use environment variable for safety

            $session = \Stripe\Checkout\Session::create([
                'mode' => 'payment',
                'success_url' => 'https://your-domain.com/payment_success.html',
                'cancel_url' => 'https://your-domain.com/payment_cancel.html',
                'line_items' => [[
                    'price_data' => [
                        'currency' => 'bdt',
                        'product_data' => ['name' => "Wavoo Order #$order_id"],
                        'unit_amount' => $amount * 100, // Stripe expects smallest unit
                    ],
                    'quantity' => 1,
                ]],
                'metadata' => [
                    'order_id' => $order_id,
                    'tran_id'  => $tran_id,
                ],
            ]);

            echo json_encode([
                'success' => true,
                'method' => 'stripe',
                'tran_id' => $tran_id,
                'pay_url' => $session->url
            ]);
            exit;


        /* -------------------------------------------------------- *
         * ❌ Unsupported method
         * -------------------------------------------------------- */
        default:
            echo json_encode(['success' => false, 'msg' => 'Unsupported payment method']);
            exit;
    }

} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'msg' => 'Server error: ' . $e->getMessage()
    ]);
}
?>
