<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

include '../connection.php';

if (isset($_POST['user_id'], $_POST['service_id'])) {
    $userId = intval($_POST['user_id']);
    $serviceId = intval($_POST['service_id']);

    $stmt = $conn->prepare("DELETE FROM tblcart WHERE user_id = ? AND service_id = ?");
    $stmt->bind_param("ii", $userId, $serviceId);

    if ($stmt->execute()) {
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['success' => false, 'error' => $stmt->error]);
    }

    $stmt->close();
} else {
    echo json_encode(['success' => false, 'error' => 'Missing parameters']);
}

$conn->close();
?>

