<?php
/*
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

include '../connection.php';


if (!isset($_POST['service_id'])) {
    echo json_encode(["error" => "No service_id provided"]);
    exit;
}

$service_id = intval($_POST['service_id']);

$sql = "SELECT name as service_name FROM tbl_service_type WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $service_id);
$stmt->execute();
$result = $stmt->get_result();

if ($row = $result->fetch_assoc()) {
    echo json_encode(["service_name" => $row['service_name']]);
} else {
    echo json_encode(["service_name" => "Unknown Service"]);
}

$stmt->close();
$conn->close();
*/

header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

include '../connection.php';

// Validate input
if (!isset($_POST['service_id']) || !is_numeric($_POST['service_id'])) {
    echo json_encode(["error" => "No or invalid service_id provided"]);
    exit;
}

$service_id = intval($_POST['service_id']);

$sql = "SELECT name FROM tbl_service_type WHERE id = ?";
$stmt = $conn->prepare($sql);

if (!$stmt) {
    echo json_encode(["error" => "Prepare failed", "mysql_error" => $conn->error]);
    exit;
}

$stmt->bind_param("i", $service_id);

if (!$stmt->execute()) {
    echo json_encode(["error" => "Execute failed", "mysql_error" => $stmt->error]);
    exit;
}

// ✅ Use bind_result instead of get_result
$stmt->bind_result($service_name);

if ($stmt->fetch()) {
    echo json_encode(["service_name" => $service_name]);
} else {
    echo json_encode(["service_name" => "Unknown Service"]);
}

$stmt->close();
$conn->close();
