<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

include '../connection.php';

$user_id = isset($_GET['user_id']) ? intval($_GET['user_id']) : 0;

if ($user_id <= 0) {
    echo json_encode(["success" => false, "message" => "Invalid user ID"]);
    exit;
}

$sql = "SELECT c.id, c.product_id, c.service_id, c.quantity, 
               p.price AS unit_price, 
               (c.quantity * p.price) AS total_price
        FROM tblcart c, tbl_service_product_prices p 
        WHERE c.product_id = p.product_id
        and c.service_id = p.service_id
        and c.user_id = ?";

$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();

$items = [];
while ($row = $result->fetch_assoc()) {
    $items[] = [
        "product_id" => (int)$row["product_id"],
        "service_id" => (int)$row["service_id"],
        "quantity" => (int)$row["quantity"],
        "unit_price" => (float)$row["unit_price"],
        "total_price" => (float)$row["total_price"]
    ];
}

if (count($items) > 0) {
    echo json_encode(["success" => true, "items" => $items]);
} else {
    echo json_encode(["success" => false, "message" => "No cart items found"]);
}

$stmt->close();
$conn->close();
?>
