<?php
error_reporting(0);
ini_set('display_errors', 0);

header("Access-Control-Allow-Origin: *");
header('Content-Type: application/json');
include '../connection.php';

// get POST params
$user_id = isset($_POST['user_id']) ? intval($_POST['user_id']) : 0;
$address = isset($_POST['address']) ? trim($_POST['address']) : '';
$latitude = isset($_POST['latitude']) && $_POST['latitude'] !== '' ? floatval($_POST['latitude']) : null;
$longitude = isset($_POST['longitude']) && $_POST['longitude'] !== '' ? floatval($_POST['longitude']) : null;
$delivery_mode_id = isset($_POST['delivery_mode_id']) && $_POST['delivery_mode_id'] !== '' ? intval($_POST['delivery_mode_id']) : null;
$delivery_charge = isset($_POST['delivery_charge']) && $_POST['delivery_charge'] !== '' ? floatval($_POST['delivery_charge']) : 0.00;

if ($user_id <= 0) {
    echo json_encode(['success' => false, 'message' => 'Invalid user']);
    exit;
}

// check if there's already a pickup location for this user
$checkSql = "SELECT id FROM tbl_pickup_location WHERE user_id = ? LIMIT 1";
$stmt = $conn->prepare($checkSql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$stmt->store_result();

if ($stmt->num_rows > 0) {
    // update
    $stmt->bind_result($existing_id);
    $stmt->fetch();
    $stmt->close();

    if ($delivery_mode_id === null) {
        $updateSql = "UPDATE tbl_pickup_location SET address = ?, latitude = ?, longitude = ?, delivery_mode_id = NULL, delivery_charge = ?, updated_at = NOW() WHERE id = ?";
        $up = $conn->prepare($updateSql);
        $up->bind_param("sdddi", $address, $latitude, $longitude, $delivery_charge, $existing_id);
    } else {
        $updateSql = "UPDATE tbl_pickup_location SET address = ?, latitude = ?, longitude = ?, delivery_mode_id = ?, delivery_charge = ?, updated_at = NOW() WHERE id = ?";
        $up = $conn->prepare($updateSql);
        $up->bind_param("sddidi", $address, $latitude, $longitude, $delivery_mode_id, $delivery_charge, $existing_id);
    }

    $ok = $up->execute();
    $up->close();

    if ($ok) {
        echo json_encode(['success' => true, 'message' => 'Pickup location updated']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Failed to update pickup location']);
    }
} else {
    $stmt->close();

    if ($delivery_mode_id === null) {
        $insertSql = "INSERT INTO tbl_pickup_location (user_id, address, latitude, longitude, delivery_mode_id, delivery_charge, created_at) VALUES (?, ?, ?, ?, NULL, ?, NOW())";
        $ins = $conn->prepare($insertSql);
        $ins->bind_param("isdid", $user_id, $address, $latitude, $longitude, $delivery_charge);
    } else {
        $insertSql = "INSERT INTO tbl_pickup_location (user_id, address, latitude, longitude, delivery_mode_id, delivery_charge, created_at) VALUES (?, ?, ?, ?, ?, ?, NOW())";
        $ins = $conn->prepare($insertSql);
        $ins->bind_param("isdidi", $user_id, $address, $latitude, $longitude, $delivery_mode_id, $delivery_charge);
    }

    $ok = $ins->execute();
    $ins->close();

    if ($ok) {
        echo json_encode(['success' => true, 'message' => 'Pickup location saved']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Failed to save pickup location']);
    }
}

$conn->close();

