<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
header("Content-Type: application/json");
include '../connection.php';

$sqlQuery = "
SELECT 
    o.*, 
    u.fname AS user_fname, 
    u.lname AS user_lname 
FROM 
    tbl_order o
JOIN 
    tblcred u ON o.user_id = u.userid
WHERE 
    o.status = 'Submitted'
    and o.assign_del_status is null
ORDER BY 
    o.id DESC
";

$result = $conn->query($sqlQuery);

if ($result && $result->num_rows > 0) {
    $orders = [];
    while ($row = $result->fetch_assoc()) {
        $orders[] = $row;
    }
    echo json_encode(["success" => true, "orders" => $orders]);
} else {
    echo json_encode(["success" => false, "message" => "No orders found"]);
}
?>
