<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
include '../connection.php';

$sql = "
SELECT 
  spp.id,
  spp.price,
  s.name AS service_name,
  p.name AS product_name
FROM tbl_service_product_prices spp
JOIN tbl_service_type s ON spp.service_id = s.id
JOIN tbl_product_type p ON spp.product_id = p.id
ORDER BY s.name, p.name";

$result = $conn->query($sql);

if ($result && $result->num_rows > 0) {
    $data = [];
    while ($row = $result->fetch_assoc()) {
        $data[] = $row;
    }
    echo json_encode([
        "success" => true,
        "data" => $data
    ]);
} else {
    echo json_encode([
        "success" => false,
        "message" => "No pricing data found"
    ]);
}
$conn->close();
?>