<?php
/*
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
include '../connection.php';

$sql = "SELECT id, country_name FROM tbl_country ORDER BY country_name ASC";
$result = $conn->query($sql);

if ($result && $result->num_rows > 0) {
    $countries = [];
    while ($row = $result->fetch_assoc()) {
        $countries[] = $row;
    }
    echo json_encode(["success" => true, "data" => $countries], JSON_UNESCAPED_UNICODE);
} else {
    echo json_encode(["success" => false, "message" => "No countries found"]);
}

$conn->close();

*/
ini_set('memory_limit', '1024M');
ini_set('max_execution_time', 0);
error_reporting(E_ALL);
ini_set('display_errors', 1);

header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");

include '../connection.php';

$sql = "SELECT id, country_name FROM tbl_country ORDER BY country_name ASC";
$result = $conn->query($sql);

if ($result && $result->num_rows > 0) {
    echo '{"success": true, "data":['; 
    $first = true;
    while ($row = $result->fetch_assoc()) {
        if (!$first) echo ',';
        echo json_encode($row, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
        $first = false;
        flush(); // send partial data
    }
    echo ']}';
} else {
    echo json_encode(["success" => false, "message" => "No countries found"]);
}

$conn->close();

?>








<?php
/*
ini_set('memory_limit', '256M');   // or higher if needed
ini_set('max_execution_time', '60');
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

ini_set('display_errors', 1);
error_reporting(E_ALL);

include '../connection.php';

if (!$conn) {
    echo json_encode(["success" => false, "message" => "Connection failed: " . mysqli_connect_error()]);
    exit;
}

$sql = "SELECT id, country_name FROM tbl_country ORDER BY country_name ASC";
$result = $conn->query($sql);

if (!$result) {
    echo json_encode(["success" => false, "message" => "SQL Error: " . $conn->error]);
    exit;
}

$countries = [];

if ($result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        $countries[] = $row;
    }
    echo json_encode(["success" => true, "data" => $countries]);
} else {
    echo json_encode(["success" => false, "message" => "No countries found"]);
}

$conn->close();
echo "connection included";
*/
?>

