<?php
header("Content-Type: application/json");
include '../connection.php';

$deliverymanId = $_GET['deliveryman_id'] ?? null;

if (!$deliverymanId) {
    echo json_encode(["success" => false, "message" => "Missing deliveryman ID"]);
    exit;
}

$sql = "SELECT COUNT(*) AS completed_count 
        FROM tbl_delevery_assign 
        WHERE deliveryman_id = ? AND status_id = 5";
$stmt = mysqli_prepare($conn, $sql);
mysqli_stmt_bind_param($stmt, "i", $deliverymanId);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);

if ($row = mysqli_fetch_assoc($result)) {
    echo json_encode([
        "success" => true,
        "completed_count" => (int)$row['completed_count']
    ]);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Could not fetch data"
    ]);
}

mysqli_stmt_close($stmt);
mysqli_close($conn);
?>
