<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

include '../connection.php';


if (!isset($_POST['user_id'])) {
    echo json_encode([
        "success" => false,
        "message" => "User ID is required"
    ]);
    exit;
}

$user_id = intval($_POST['user_id']);

// Check if user has any previous orders
$query = "SELECT COUNT(*) as total FROM tbl_order WHERE status = 'Submitted' and user_id = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result()->fetch_assoc();

if ($result['total'] == 0) {
    // First order
    echo json_encode([
        "success" => true,
        "isFirstOrder" => true,
        "message" => "This is the user’s first order"
    ]);
} else {
    // Not first order
    echo json_encode([
        "success" => true,
        "isFirstOrder" => false,
        "message" => "This user has previous orders"
    ]);
}
?>