<?php
header("Access-Control-Allow-Origin: *");
header('Content-Type: application/json');
include '../connection.php';

$user_id = $_GET['user_id'];

if (!$user_id) {
    echo json_encode(["success" => false, "message" => "Missing user_id"]);
    exit;
}

$stmt = $conn->prepare("SELECT address, latitude, longitude FROM tbl_pickup_location WHERE user_id = ? ORDER BY id ASC LIMIT 1");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();

if ($row = $result->fetch_assoc()) {
    echo json_encode(["success" => true, "data" => $row]);
} else {
    echo json_encode(["success" => false, "message" => "No location found"]);
}
?>
