<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
include '../connection.php';

$service_id = $_POST["service_id"];

$sql = "SELECT p.id as product_id, p.name as product_name, sp.price
        FROM tbl_product_type p
        JOIN tbl_service_product_prices sp 
          ON p.id = sp.product_id
        WHERE sp.service_id = ?";
        
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $service_id);
$stmt->execute();
$result = $stmt->get_result();

$products = [];
while ($row = $result->fetch_assoc()) {
    $products[] = $row;
}

echo json_encode([
    "success" => true,
    "products" => $products
]);
