<?php
header("Access-Control-Allow-Origin: *");
header('Content-Type: application/json');
include '../connection.php';

$user_id = isset($_POST['user_id']) ? intval($_POST['user_id']) : 0;

if($user_id <= 0){
    echo json_encode(['success' => false, 'message' => 'Invalid user ID']);
    exit;
}

$query = "SELECT * FROM tbl_profile WHERE user_id = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();

if($result->num_rows > 0){
    $row = $result->fetch_assoc();
    echo json_encode(['success' => true, 'data' => $row]);
} else {
    echo json_encode(['success' => true, 'data' => null]);
}

$stmt->close();
$conn->close();
?>
