<?php
header("Access-Control-Allow-Origin: *");
header('Content-Type: application/json');
include '../connection.php';

if(isset($_POST['user_id'])) {
    $user_id = intval($_POST['user_id']);

    $query = "SELECT conno FROM tblcred WHERE userid = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();

    if($row = $result->fetch_assoc()){
        echo json_encode([
            "success" => true,
            "conno" => $row['conno']
        ]);
    } else {
        echo json_encode([
            "success" => false,
            "message" => "Contact number not found"
        ]);
    }
} else {
    echo json_encode([
        "success" => false,
        "message" => "Missing user_id"
    ]);
}
?>
